#ifndef _CMEMPOOL_CPP
#define _CMEMPOOL_CPP
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <WinLDAP.H> // Requires WLDAP32.Lib

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "Entry.H"
#include "CCmdLine.H"

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

CCmdLine::CCmdLine()
{
    sArray = NULL;
    iCount = NULL;
    iLen = NULL;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

CCmdLine::~CCmdLine()
{
    sArray = NULL;
    iCount = NULL;
    iLen = NULL;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CCmdLine::ParseCmdEx(char *sCmdLine, int *iOutMaxLen, bool bEval)
{
	bool bInQuote = false;

	char *sBuf = NULL;

	int iCmdSz = strlen(sCmdLine);
	int iMaxLen = 0;
	int iRPos = 0;
	int iWPos = 0;

	if(!bEval)
	{
		if(!ParseCmdEx(sCmdLine, &iMaxLen, true))
		{
			return false;
		}

		sArray = (char **) gMem.Allocate(sizeof(char *), iCount);
		sBuf = (char *) gMem.Allocate(sizeof(char), iMaxLen + 1);
		iLen = (int *) gMem.Allocate(sizeof(int), iMaxLen + 1);

		iCount = 0;
	}
	
	while(iRPos < iCmdSz)
	{
		if(sCmdLine[iRPos] == '\"')
		{
			bInQuote = !bInQuote;
			iRPos++;
			continue;
		}

		if(sCmdLine[iRPos] == ' ' && bInQuote == false)
		{
			if(!bEval)
			{
				sBuf[iWPos] = '\0';
				
				iLen[iCount] = iWPos;
				sArray[iCount] = (char *) gMem.Allocate(sizeof(char), iWPos + 1);
				strcpy_s(sArray[iCount], iWPos + 1, sBuf);
			}
			else{
				if(iWPos > *iOutMaxLen)
				{
					*iOutMaxLen = iWPos;
				}
			}

			//Skip white spaces.
			while(iRPos < iCmdSz && sCmdLine[iRPos] == ' ')
			{
				iRPos++;
			}

			iCount++;

			iWPos = 0;
		}
		else{
			if(!bEval)
			{
				sBuf[iWPos++] = sCmdLine[iRPos++];
			}
			else {
				iWPos++;
				iRPos++;
			}
		}
	}

	if(iWPos > 0)
	{
		if(!bEval)
		{
			sBuf[iWPos] = '\0';

			iLen[iCount] = iWPos;
			sArray[iCount] = (char *) gMem.Allocate(sizeof(char), iWPos + 1);
			strcpy_s(sArray[iCount], iWPos + 1, sBuf);
		}
		else {
			if(iWPos > *iOutMaxLen)
			{
				*iOutMaxLen = iWPos;
			}
		}

		iCount++;
	}

	if(!bEval)
	{
		gMem.Free(sBuf);
	}

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CCmdLine::Alloc(void)
{
	return ParseCmdEx(GetCommandLine(), NULL, false);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CCmdLine::Free(void)
{
	int iArg = 0;

	while(iArg < iCount)
	{
		gMem.Free(sArray[iArg]);
		sArray[iArg] = NULL;

		iArg++;
	}

	gMem.Free(sArray);
	gMem.Free(iLen);

    return true;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
